/**
* \file: msd.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_BACKENDS_MSD_EVENTS_H
#define AAM_BACKENDS_MSD_EVENTS_H

#include <libudev.h>
#include <stddef.h>
#include "control/automounter.h"

/**
 * declaration of a uevent info cache data structure.
 *
 * This data structure is used for caching information read out about a device or partition from the uevent or
 * using different mechanisms. The idea is to cache attributes once they are read out to speed up multiple accesses
 * to them.
 */
typedef struct msd_uevent_info_cache msd_uevent_info_cache_t;

/**
 * Initializes the given event info cache structure
 * This member is called on an incoming uevent. Several get functions are provided to extract information from
 * this uevent data structure. Depending on how expensive it is to extract the data item,
 * the information might be cached.
 * \param the udev device structure that contains the uevent information
 * \param uevent_info_cache a ptr to the event info cache structure to be initialized
 */
void msd_uevent_init(struct udev_device *udevice, msd_uevent_info_cache_t *uevent_info_cache);

/**
 * Called to free all resources that might have been used for caching the uevent data associated with the given cache
 * data structure. The data structure itself is not freed.
 */
void msd_uevent_deinit(msd_uevent_info_cache_t *uevent_info_cache);

/**
 * Get attribute functions of event info cache structure
 */

//return NULL in case we are unable to get the device node
const char *msd_uevent_get_dev_node(msd_uevent_info_cache_t *uevent_info_cache);

//return NULL in case we are unable to get the device type
const char *msd_uevent_get_dev_type(msd_uevent_info_cache_t *uevent_info_cache);

//return 0 in all case we do not find a partition table or are unable to read it or ...
int msd_uevent_get_partition_cnt(msd_uevent_info_cache_t *uevent_info_cache);

//return 1 in case we are unable to get the number
int msd_uevent_get_partition_number(msd_uevent_info_cache_t *uevent_info_cache);

//return NULL in case we are unable to get the file system
const char *msd_uevent_get_filesystem(msd_uevent_info_cache_t *uevent_info_cache);

//return NULL in case we are unable to get the file system UUID
const char *msd_uevent_get_filesystem_uuid(msd_uevent_info_cache_t *uevent_info_cache);

//return false in any case we are unable to detect audio data
bool msd_uevent_contains_cdda(msd_uevent_info_cache_t *uevent_info_cache);

/**
 * Generic functions to get properties from uevent
 */
const char *msd_uevent_get_value_from_udevice_property_or_default(msd_uevent_info_cache_t *uevent_info_cache, const char *property_name, const char *default_val);

int msd_uevent_get_intvalue_from_udevice_property(msd_uevent_info_cache_t *uevent_info_cache, const char *property_val, int default_val);

/**
* Generuc function to get sys attribute value
*/

long msd_uevent_get_longvalue_sys_attr_or_default(msd_uevent_info_cache_t *uevent_info_cache, const char *property_name, int default_val);
/**
 * Returns the size of event info cache structure
 */
size_t msd_uevent_get_size_cache(void);

//might return NULL if the parent device does not exist or is not from type disk (see: msd_metada_determine_parent_device())
struct udev_device *msd_uevent_determine_parent_device(msd_uevent_info_cache_t *uevent_info_cache);

#endif /* MSD_EVENTS_H_ */
